<?php
/**
 * Template scriptcase.
 *
 * Configuracao dos caracteres validos para um campo.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2004/01/21
 * @copyright   NetMake Solucoes em Informatica
 * @author      Luis Humberto Roman <romanlh@netmake.com.br>
 *
 * $Id: body_form_ext_date_limit.tpl.php,v 1.1.1.1 2011-05-12 20:31:14 diogo Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

$arr_data = $this->GetVar('field_data');
$str_class = ($arr_data['error']) ? 'nmErrorMsg' : $arr_data['class'];
$str_mod = $arr_data['time_mod'];

$upgrade_no_permission  = isset($arr_data['upgrade_no_permission'])? $arr_data['upgrade_no_permission'] : false;
$label_new_opt  = isset($arr_data['label_new_opt'])? $arr_data['label_new_opt'] : false;

$disabled_no_permission = '';
if ($upgrade_no_permission) {
    $disabled_no_permission = ' disabled="disabled"';
}

?>
<tr class="nmTrAttr nmTrHover">
    <td class="nmAttrTitle <?php echo $str_class; ?>"
        style="text-align: right; vertical-align: top"><?php echo $arr_data['title']; ?><a
            name="anchor_<?php echo $arr_data['name']; ?>"></a>
        <?php if ($upgrade_no_permission) {?>
            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']"); ?></small>
        <?php } else if ($label_new_opt) { ?>
            <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
        <?php } ?>
    </td>
    <td class="<?php echo $str_class; ?>" style="text-align: right; vertical-align: top;">&nbsp;</td>
    <td class="<?php echo $str_class; ?>" style="text-align: left; vertical-align: top">
        <table style="border-collapse: collapse; border-width: 0px">
            <tr>
                <?php
                $str_id_random = nm_id_random('chk_tmfx');
                ?>
                <td style="padding: 0px 0px 0px 0px; white-space: nowrap; vertical-align:top"><span class="nmText">
                        <input type="checkbox" style="margin:0px"
                               name="time_<?php echo $str_mod; ?>_fix"
                               value="1"<?php if (1 == $arr_data['time_option']) {
                            echo 'checked="checked"';
                        } ?> onClick="<?php echo $nm_config['form_modif2']; ?>; nm_toggle_time_option('<?php echo $str_mod; ?>', 'fix')"
                               id="<?php echo $str_id_random; ?>"<?php echo $disabled_no_permission ?>/></span>
                </td>
                <td style="padding: 0px 0px 0px 0px; white-space: nowrap"><span class="nmText" style="margin: 5px;"><label
                            for="<?php echo $str_id_random; ?>"><?php echo nm_get_text_lang("['timelim_fixed']"); ?></label></span>
                </td>
            </tr>
            <tr>
                <td style="padding: 0px 0px 0px 0px; white-space: nowrap"><span class="nmText">&nbsp;</span></td>
                <td style="padding: 0px 0px 0px 0px; white-space: nowrap"><span class="nmText" style="margin: 5px;">
      <input type="text" name="time_<?php echo $str_mod; ?>_hour" value="<?php echo $arr_data['time_hour']; ?>" size="2"
             maxlength="2" class="nmInput <?php echo ($upgrade_no_permission)?"upgradeDisabled":""; ?>" onChange="<?php echo $nm_config['form_modif2']; ?>" onclick="<?php echo (isset($arr_data['on_click']) && !empty($arr_data['on_click']))?$arr_data['on_click']:""; ?>"/>
      <input type="text" name="time_<?php echo $str_mod; ?>_minute" value="<?php echo $arr_data['time_minute']; ?>"
             size="2" maxlength="2" class="nmInput <?php echo ($upgrade_no_permission)?"upgradeDisabled":""; ?>" onChange="<?php echo $nm_config['form_modif2']; ?>" onclick="<?php echo (isset($arr_data['on_click']) && !empty($arr_data['on_click']))?$arr_data['on_click']:""; ?>"/>
      <input type="text" name="time_<?php echo $str_mod; ?>_second" value="<?php echo $arr_data['time_second']; ?>" size="2"
             maxlength="2" class="nmInput <?php echo ($upgrade_no_permission)?"upgradeDisabled":""; ?>" onChange="<?php echo $nm_config['form_modif2']; ?>" onclick="<?php echo (isset($arr_data['on_click']) && !empty($arr_data['on_click']))?$arr_data['on_click']:""; ?>"/>
     </span></td>
            </tr>
            <tr>
                <?php
                $str_id_random = nm_id_random('chk_tmnw');
                ?>
                <td style="padding: 0px 0px 0px 0px; white-space: nowrap;vertical-align:top"><span class="nmText"><input type="checkbox" style="margin:0px"
                                                                                                                         name="time_<?php echo $str_mod; ?>_now"
                                                                                                                         value="2"<?php if (2 == $arr_data['time_option']) {
                            echo 'checked="checked"';
                        } ?> onClick="<?php echo $nm_config['form_modif2']; ?>; nm_toggle_time_option('<?php echo $str_mod; ?>', 'now')"
                                                                                                                         id="<?php echo $str_id_random; ?>"<?php echo $disabled_no_permission ?>/></span>
                </td>
                <td style="padding: 0px 0px 0px 0px; white-space: nowrap"><span class="nmText" style="margin: 5px;"><label
                            for="<?php echo $str_id_random; ?>"><?php echo nm_get_text_lang("['timelim_actual']"); ?></label></span>
                </td>
            </tr>
            <tr>
                <td style="padding: 0px 0px 0px 0px; white-space: nowrap"><span class="nmText">&nbsp;</span></td>
                <td style="padding: 0px 0px 0px 0px; white-space: nowrap"><span class="nmText" style="margin: 5px;">
      <input type="text" name="time_<?php echo $str_mod; ?>_exp" value="<?php echo $arr_data['time_exp']; ?>" size="15"
             class="nmInput <?php echo ($upgrade_no_permission)?"upgradeDisabled":""; ?>" onChange="<?php echo $nm_config['form_modif2']; ?>" onclick="<?php echo (isset($arr_data['on_click']) && !empty($arr_data['on_click']))?$arr_data['on_click']:""; ?>"/>
<?php
if (!$upgrade_no_permission) {
?>
      <a href="javascript: nm_window_time_limit('form_edit', 'time_<?php echo $str_mod; ?>_exp', '<?php echo $nm_config['form_modif']; ?>')"><img
              src="<?php echo $nm_config['url_img']; ?>wizard.gif" style="border-width: 0px"/></a>
<?php
}
?>
     </span></td>
            </tr>
        </table>
    </td>
    <td class="<?php echo $str_class; ?>" style="text-align: right; vertical-align: top;">&nbsp;</td>
    <td class="nmLineDesc" style="text-align: left; vertical-align: top"><?php echo $arr_data['desc']; ?></td>
</tr>
