<?php
/**
 * Template scriptcase.
 *
 * Modulo de Seguranca.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: body_security_module_step_associar.tpl.php,v 1.5 2012-01-25 13:52:25 vinicius Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

$arr_tables = $this->GetVar('arr_tables');

?>

<div class="ui grid">
    <div class="left floated twelve wide column" style="text-align: left;">

        <h3 class="ui header"><?php echo nm_get_text_lang("['assoc']"); ?></h3>
    </div>

    <div class="right floated two wide column"
         style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
        <?php echo $this->GetVar('block_image_help'); ?>
    </div>
</div>
<div class="ui divider"></div>

<div class="ui top attached tabular menu">
    <a class="active item" id='inbox_aba'
       data-tab="inbox"><label><?php echo nm_get_text_lang("['inbox']['title']"); ?></label></a>
    <a class="item" id='pref_aba'
       data-tab="pref"><label><?php echo nm_get_text_lang("['pref']['title']"); ?></label></a>
    <a class="item" id='tags_aba'
       data-tab="tags"><label><?php echo nm_get_text_lang("['tags']['title']"); ?></label></a>

    <a class="item" id='notifications_aba'
       data-tab="notifications"><label><?php echo nm_get_text_lang("['notifications']['title']"); ?></label></a>

    <a class="item" id='profiles_aba'
       data-tab="profiles"><label><?php echo nm_get_text_lang("['profiles']['title']"); ?></label></a>

    <a class="item" id='user_tags_aba'
       data-tab="user_tags"><label><?php echo nm_get_text_lang("['user_tags']['title']"); ?></label></a>

</div>

<div class="ui bottom attached active tab segment" data-tab="inbox" id="inbox">
    <?php
    $i = 0;
    $this_table = 'inbox';
    $arr_fields = ['inbox_id', 'notif_id', 'login', 'notif_dtsent', 'notif_ontop', 'notif_isread', 'notif_dtread', 'notif_tags', 'notif_important'];
    ?>
    <div class="ui">
        <div class="ui form">
            <div class="field">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables ui fluid dropdown search selection' name='<?php echo $this_table; ?>[table]'
                            onChange="ajaxGetFields(this.value, '<?php echo $this_table; ?>');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
            </div>
            <div class="fields two">
                <?php

                foreach ($arr_fields as $field):
$i++;
                    ?>

                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['" . $field . "']"); ?></label>


                        <select name='<?php echo $this_table . "[" . $field . "]"; ?>'
                                class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                    <?php
                    if ($i % 2 == 0 && $i != count($arr_fields)) {
                        echo '</div><div class="fields two">';
                    }
                endforeach; ?>
            </div>


        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="pref" id="pref">
    <?php
    $i = 0;
    $this_table = 'pref';
    $arr_fields = ['login', 'receive_email', 'receive_sms'];
    ?>
    <div class="ui">
        <div class="ui form">
            <div class="field ">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables ui fluid dropdown search selection' name='<?php echo $this_table; ?>[table]'
                            onChange="ajaxGetFields(this.value, '<?php echo $this_table; ?>');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
            </div>
            <div class="fields two">
                <?php

                foreach ($arr_fields as $field):
$i++;
                    ?>

                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['" . $field . "']"); ?></label>


                        <select name='<?php echo $this_table . "[" . $field . "]"; ?>'
                                class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                    <?php
                    if ($i % 2 == 0 && $i != count($arr_fields)) {
                        echo '</div><div class="fields two">';
                    }
                endforeach; ?>
            </div>


        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="tags" id="tags">
    <?php
    $i = 0;
    $this_table = 'tags';
    $arr_fields = ['tag_id', 'tag_title', 'login', 'tag_color', 'tag_active',];
    ?>
    <div class="ui">
        <div class="ui form">
            <div class="field">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables ui fluid dropdown search selection' name='<?php echo $this_table; ?>[table]'
                            onChange="ajaxGetFields(this.value, '<?php echo $this_table; ?>');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
            </div>
            <div class="fields two">
                <?php

                foreach ($arr_fields as $field):
$i++;
                    ?>

                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['" . $field . "']"); ?></label>


                        <select name='<?php echo $this_table . "[" . $field . "]"; ?>'
                                class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                    <?php
                    if ($i % 2 == 0 && $i != count($arr_fields)) {
                        echo '</div><div class="fields two">';
                    }
                endforeach; ?>
            </div>


        </div>
    </div>
</div>
<div class="ui bottom attached tab segment" data-tab="notifications" id="notifications">
    <?php
    $i = 0;
    $this_table = 'notifications';
    $arr_fields = ['notif_id', 'notif_title', 'notif_message', 'notif_dtcreated', 'notif_ontop', 'notif_dtexpire', 'notif_categ', 'notif_login_sender',
        'notif_type', 'notif_link', 'deleted_at'];
    ?>
    <div class="ui">
        <div class="ui form">
            <div class="field">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables ui fluid dropdown search selection' name='<?php echo $this_table; ?>[table]'
                            onChange="ajaxGetFields(this.value, '<?php echo $this_table; ?>');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
            </div>
            <div class="fields two">
                <?php

                foreach ($arr_fields as $field):
$i++;
                    ?>

                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['" . $field . "']"); ?></label>


                        <select name='<?php echo $this_table . "[" . $field . "]"; ?>'
                                class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                    <?php
                    if ($i % 2 == 0 && $i != count($arr_fields)) {
                        echo '</div><div class="fields two">';
                    }
                endforeach; ?>
            </div>


        </div>
    </div>
</div>

<div class="ui bottom attached tab segment" data-tab="profiles" id="profiles">
    <?php
    $i = 0;
    $this_table = 'profiles';
    $arr_fields = ['profile_id', 'profile_name', 'profile_users', 'profile_groups', 'profile_public', 'profile_owner'];
    ?>
    <div class="ui">
        <div class="ui form">
            <div class="field">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables ui fluid dropdown search selection' name='<?php echo $this_table; ?>[table]'
                            onChange="ajaxGetFields(this.value, '<?php echo $this_table; ?>');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
            </div>
            <div class="fields two">
                <?php

                foreach ($arr_fields as $field):
$i++;
                    ?>

                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['" . $field . "']"); ?></label>


                        <select name='<?php echo $this_table . "[" . $field . "]"; ?>'
                                class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                    <?php
                    if ($i % 2 == 0 && $i != count($arr_fields)) {
                        echo '</div><div class="fields two">';
                    }
                endforeach; ?>
            </div>


        </div>
    </div>
</div>

<div class="ui bottom attached tab segment" data-tab="user_tags" id="user_tags">
    <?php
    $i = 0;
    $this_table = 'user_tags';
    $arr_fields = ['user_tags_id','login', 'login_sender', 'tags'];
    ?>
    <div class="ui">
        <div class="ui form">
            <div class="field">
                <div class='field'>

                    <label><?php echo nm_get_text_lang("['table']"); ?></label>


                    <select class='select_tables ui fluid dropdown search selection' name='<?php echo $this_table; ?>[table]'
                            onChange="ajaxGetFields(this.value, '<?php echo $this_table; ?>');">
                        <option value=""></option>
                        <?php
                        foreach ($arr_tables as $table) {
                            echo "<option value='" . $table . "'>" . $table . "</option>";
                        }
                        ?>
                    </select>

                </div>
            </div>
            <div class="fields two">
                <?php

                foreach ($arr_fields as $field):
$i++;
                    ?>

                    <div class='field'>

                        <label><?php echo nm_get_text_lang("['" . $field . "']"); ?></label>


                        <select name='<?php echo $this_table . "[" . $field . "]"; ?>'
                                class='select_fields search ui fluid dropdown selection'>

                        </select>

                    </div>
                    <?php
                    if ($i % 2 == 0 && $i != count($arr_fields)) {
                        echo '</div><div class="fields two">';
                    }
                endforeach; ?>
            </div>


        </div>
    </div>
</div>
